<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('frontend/user/assets/css/custom.css')); ?>" rel="stylesheet" />
    <style>
        .typeDemoImg {
            width: 50%;
            margin: 5px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('user-content'); ?>
    <?php if(site_info()->instanat_verify_active == 1): ?>
        <div class="row justify-content-center pt-4">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="text-start"><h3>Instant Verify</h3></div>
                    </div>
                    <div class="card-body text-center">
    
                        <h6 class="text-center"><?php echo e(site_info()->instant_verify_note); ?></h6>
                        
                        <?php if(Auth::user()->deposit_balance > 0): ?>
                            <a href="<?php echo e(route('user.instant-verify-my-account')); ?>" class="btn btn-warning btn-sm text-dark" onclick="return confirm('Are you sure?')">Instant verify My Account</a>
                        <?php else: ?>
                            <a href="<?php echo e(route('user.deposit')); ?>" class="btn btn-success btn-sm text-dark" style="background:#fec30f;border:none;">Please! Deposit for instant verify.</a>
                        <?php endif; ?>
    
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if(site_info()->need_user_verification == 1): ?>
        <div class="row justify-content-center pt-4">
            <div class="col-lg-6">
                <form action="<?php echo e(route('user.account-verify-with-document-store')); ?>" id="account_verify_form" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-header pb-0">
                            <div class="text-start"><h3>Manually Account Verification</h3></div>
                            <div>
                                <?php if(account_verify_document() && account_verify_document()->status == 0): ?>
                                    <h4 class="m-0 text-danger text-start"><strong>Document submited and now it under verification!</strong></h4>
                                <?php elseif(account_verify_document() && account_verify_document()->status == 2): ?>
                                    <h4 class="m-0 text-danger text-start"><strong>Document submited but this information rejected, please submit your valid document again!</strong></h4>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <div>
                                <h5>Attention Please</h5>
                                <ul>
                                    <li> <strong>Img section - </strong>Don't Use copy Img.</li>
                                    <li> <strong>Document section -</strong> Don't upload fack or edited Document .</li>
                                    <li> <strong> Verification Documents -</strong> Always use real and clear img for Verification.</li>
                                    <li> <strong>Ban Warning -</strong> If you uplaod fack or edited document then your account will be permanently Ban without any warning.</li>
                                </ul>
                            </div>
                            
                            <div class="form-group">
                                <label for="document_type">Select Verify Card*</label>
                                <select class="form-control" name="document_type" id="document_type" required onchange="changeCardType()">
                                    <option value="NID" <?php if(account_verify_document() && account_verify_document()->document_type == "NID"): ?> selected <?php endif; ?>>NID</option>
                                    <option value="Birth Certificate" <?php if(account_verify_document() && account_verify_document()->document_type == "Birth Certificate"): ?> selected <?php endif; ?>>Birth Certificate</option>
                                    <option value="Passport" <?php if(account_verify_document() && account_verify_document()->document_type == "Passport"): ?> selected <?php endif; ?>>Passport</option>
                                    <option value="Driving License" <?php if(account_verify_document() && account_verify_document()->document_type == "Driving License"): ?> selected <?php endif; ?>>Driving License</option>
                                </select>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="name">Full Name*</label>
                                <input type="text" class="form-control" name="name" required placeholder="Name which used for this account." <?php if(account_verify_document()): ?> value="<?php echo e(account_verify_document()->name); ?>" <?php endif; ?>>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="card_number">Card Number*</label>
                                <input type="text" class="form-control" name="card_number" required placeholder="Card Number." <?php if(account_verify_document()): ?> value="<?php echo e(account_verify_document()->card_number); ?>" <?php endif; ?>>
                            </div>
                            
                            <div class="form-group mt-2 card-sample" id="id_card_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/nid.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2 card-sample d-none" id="birth_certificate_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/passport.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2 card-sample d-none" id="passport_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/driver.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2 card-sample d-none" id="driving_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/bio.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="document_front">*Card এর প্রথম পেজ যেখানে আপনার নাম রয়েছে</label>
                                <input type="file" class="form-control" name="document_front" id="document_front" required onchange="readDocumentFrontURL();">
                                <?php if(account_verify_document()): ?>
                                    <div style="text-align: center;"><img src="<?php echo e(URL::to(account_verify_document()->document_front)); ?>" class="img-fluid c-pointermt-2" height="60px" width="60px" id="document_front_image" onclick="viewImage('<?php echo e(URL::to(account_verify_document()->document_front)); ?>')"></div>
                                <?php else: ?>
                                    <div style="text-align: center;"><img class="rounded border-dark" style="margin-top: 10px;max-height: 200px;" width="150px" id="document_front_image"></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="document_with_user">*Card আপনার হাতে নিয়ে আপনার মুখ সহ পিক তুলবেন</label>
                                <input type="file" class="form-control" name="document_with_user" id="document_with_user" required onchange="readDocumentWithUserURL();">
                                <?php if(account_verify_document()): ?>
                                    <div style="text-align: center;"><img src="<?php echo e(URL::to(account_verify_document()->document_with_user)); ?>" class="img-fluid c-pointermt-2" height="60px" width="60px" id="document_with_user_image" onclick="viewImage('<?php echo e(URL::to(account_verify_document()->document_with_user)); ?>')"></div>
                                <?php else: ?>
                                    <div style="text-align: center;"><img class="rounded border-dark" style="margin-top: 10px;max-height: 200px;" width="150px" id="document_with_user_image"></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-footer text-center">
                            <button type="submit" class="btn btn-outline-success bttn mt-2">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('frontend/user/assets/js/my_custom.js')); ?>"></script>
    <script>
        function changeCardType(){
            var document_type = $('#document_type').val();
            $('.card-sample').addClass('d-none');
            if(document_type == 'NID'){
                $('#id_card_sample').removeClass('d-none');
            }else if(document_type == 'Birth Certificate'){
                $('#birth_certificate_sample').removeClass('d-none');
            }else if(document_type == 'Passport'){
                $('#passport_sample').removeClass('d-none');
            }else if(document_type == 'Driving License'){
                $('#driving_sample').removeClass('d-none');
            }
        }
        
        function readDocumentFrontURL(){
            var file = $('#document_front').get(0).files[0];
            console.log(file);
            if(file){
                $('#document_front_image').show();
                var reader = new FileReader();

                reader.onload = function(){
                    $('#document_front_image').attr("src", reader.result);
                }

                reader.readAsDataURL(file);
            }
        }
        
        function readDocumentWithUserURL(){
            var file = $('#document_with_user').get(0).files[0];
            console.log(file);
            if(file){
                $('#document_with_user_image').show();
                var reader = new FileReader();

                reader.onload = function(){
                    $('#document_with_user_image').attr("src", reader.result);
                }

                reader.readAsDataURL(file);
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asditzone/public_html/resources/views/user/pages/instant-verify.blade.php ENDPATH**/ ?>